\name{saveXML}
\alias{saveXML}
\alias{saveXML.XMLInternalDocument}
\alias{saveXML.XMLInternalDOM}
\alias{saveXML.XMLInternalNode}
\alias{saveXML.XMLNode}
\alias{saveXML.XMLOutputStream}
\alias{coerce,XMLInternalDocument,character-method}
\alias{coerce,XMLInternalDOM,character-method}
\alias{coerce,XMLInternalNode,character-method}
\alias{saveXML,XMLFlatTree-method}
\alias{saveXML,XMLInternalDocument-method}
\alias{saveXML,XMLInternalDOM-method}
\alias{saveXML,XMLInternalNode-method}
\alias{saveXML,XMLNode-method}
\alias{saveXML,XMLOutputStream-method}
\alias{saveXML,HTMLInternalDocument-method}
\title{Output internal XML Tree}
\description{
  Methods for writing the representation of an XML tree to a string or
  file.
  Originally this was intended to be used only for
  DOMs (Document Object Models) stored in internal memory
  created via \code{\link{xmlTree}}, but methods for
  \code{XMLNode}, \code{XMLInternalNode} and \code{XMLOutputStream}
  objects
   (and others)
  allow it to be generic for different representations of the
  XML tree.

  Note that the indentation when writing an internal C-based node
  (XMLInternalNode) may not be as expected if there are text nodes
  within the node.

  Also, not all the parameters are meaningful for all methods.
  For example, compressing when writing to a string is not
  supported.
}
\usage{
saveXML(doc, file=NULL, compression=0, indent=TRUE, prefix = '<?xml version="1.0"?>\n',
        doctype = NULL, encoding = "", ...)
\method{saveXML}{XMLInternalDocument}(doc, file=NULL, compression=0, indent=TRUE, prefix = '<?xml version="1.0"?>\n',
                            doctype = NULL, encoding = "", ...)
\method{saveXML}{XMLInternalDOM}(doc, file=NULL, compression=0, indent=TRUE, prefix = '<?xml version="1.0"?>\n',
                       doctype = NULL, encoding = "", ...)
\method{saveXML}{XMLNode}(doc, file=NULL, compression=0, indent=TRUE, prefix = '<?xml version="1.0"?>\n',
                 doctype = NULL, encoding = "", ...)
\method{saveXML}{XMLOutputStream}(doc, file=NULL, compression=0, indent=TRUE, prefix = '<?xml version="1.0"?>\n',
                         doctype = NULL, encoding = "", ...)
}
\arguments{
  \item{doc}{the document object representing the XML document.}
  \item{file}{the name of the file to which the contents of the XML
    nodes will be serialized.}
  \item{compression}{an integer value between 0 and 9 indicating the
    level of compression to use when saving the file. Higher values
    indicate increased compression and hence smaller files
    at the expense of computational time to do the compression and decompression.}
  \item{indent}{a logical value indicating whether to indent
    the nested nodes when serializing to the stream.}
  \item{prefix}{a string that is written to the stream/connection before
     the XML is output. If this is NULL, it is ignored. This allows us to
     put the XML introduction/preamble at the beginning of the document
     while allowing it to be omitted when we are outputting multiple
     "documents" within a single stream.}
  \item{doctype}{an object identifying the elements for the DOCTYPE in the output.
    This can be a string or an object of class \code{Doctype}.}
  \item{encoding}{a string indicating which encoding style to use.  This
  is currently ignored except in the method in \code{Sxslt} for saving a
  document generated by applying an XSL style sheet to an XML document.}
  \item{\dots}{extra parameters for specific methods}
}
\details{
 One can create an internal XML tree (or DOM)
 using \code{\link{newXMLDoc}} and \code{\link{newXMLNode}}.
 \code{saveXML} allows one to generate a textual representation of
 that DOM in human-readable and reusable XML format.
 \code{saveXML} is a generic function that allows one to call
 the rendering operation with either the top-level node
 of the DOM or of the document object (of class \code{XMLInternalDocument}
 that is used to 
 accumulate the nodes and with which the developer 
 adds nodes.
}
\value{
 If \code{file} is not specified, the result is a character string containing
 the resulting XML content.
 If \code{file} is passed in the call, 
}
\references{\url{http://www.w3.org/XML}, \url{http://www.omegahat.org/RSXML}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{newXMLDoc}}
\code{\link{newXMLNode}}
\code{\link{xmlOutputBuffer}}
\code{\link{xmlOutputDOM}}
}

\examples{

 b = newXMLNode("bob")
 saveXML(b)

 f = tempfile()
 saveXML(b, f)
 doc = xmlInternalTreeParse(f)
 saveXML(doc)


con <- xmlOutputDOM()
con$addTag("author", "Duncan Temple Lang")
con$addTag("address",  close=FALSE)
con$addTag("office", "2C-259")
con$addTag("street", "Mountain Avenue.")
con$addTag("phone", close=FALSE)
con$addTag("area", "908", attrs=c(state="NJ"))
con$addTag("number", "582-3217")
con$closeTag() # phone
con$closeTag() # address

saveXML(con$value(), file="out.xml")


# Work with entities

 f = system.file("exampleData", "test1.xml", package = "XML")
 doc = xmlRoot(xmlTreeParse(f))
 outFile = tempfile()
 saveXML(doc, outFile)
 alt = xmlRoot(xmlTreeParse(outFile))
 if(! identical(doc, alt) )
  stop("Problems handling entities!")

 con = textConnection("test1.xml", "w")
 saveXML(doc, con)
 close(con)
 alt = get("test1.xml")
 identical(doc, alt)



 x = newXMLNode("a", "some text", newXMLNode("c", "sub text"), "more text")

 cat(saveXML(x), "\n")

 cat(as(x, "character"), "\n")


     # Showing the prefix parameter
  doc = newXMLDoc()
  n = newXMLNode("top", doc = doc)
  b = newXMLNode("bar", parent = n)

     # suppress the <?xml ...?>
  saveXML(doc, prefix = character())

     # put our own comment in
  saveXML(doc, prefix = "<!-- This is an alternative prefix -->")
     # or use a comment node.
  saveXML(doc, prefix = newXMLCommentNode("This is an alternative prefix"))
}
\keyword{IO}
\keyword{file}

