% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_info.R
\name{user_contributions}
\alias{user_contributions}
\title{Retrieve user contributions}
\usage{
user_contributions(
  language = NULL,
  project = NULL,
  domain = NULL,
  username,
  properties = c("ids", "title", "timestamp", "comment", "parsedcomment", "size",
    "sizediff", "flags", "tags"),
  mainspace = FALSE,
  limit = 50,
  clean_response = FALSE,
  ...
)
}
\arguments{
\item{language}{The language code of the project you wish to query,
if appropriate.}

\item{project}{The project you wish to query ("wikiquote"), if appropriate.
Should be provided in conjunction with \code{language}.}

\item{domain}{as an alternative to a \code{language} and \code{project} combination,
you can also provide a domain ("rationalwiki.org") to the URL constructor, allowing
for the querying of non-Wikimedia MediaWiki instances.}

\item{username}{The username of the user whose contributions you want to retrieve.
Due to limitations at the API end, you can only retrieve edits for one user at a time.}

\item{properties}{The metadata you want associated with each edit. Potential metadata includes "ids"
(the revision ID of the revision, which can be passed into \code{\link{revision_content}}),
"title" (the name of the page that was edited), "timestamp", "comment" (the edit summary associated
with the revision), "parsedcomment" (the same, but parsed, generating HTML from any wikitext
in that comment), "size" (the size, in uncompressed bytes, of the edit), "sizediff" (the size
delta between this edit, and the last edit to the page), "flags" (whether the revision was 
'minor' or not), and "tags" (any tags associated with the revision).}

\item{mainspace}{A boolean flag; FALSE retrieves all of the most recent contributions, while
TRUE limits the retrieved contributions to those in the 'mainspace' - in other words, edits to
actual articles. Set to FALSE by default}

\item{limit}{The number of edits to be retrieved. 50 is the maximum for logged-out API users,
and putting in more than 50 will generate a warning.}

\item{clean_response}{whether to do some basic sanitising of the resulting data structure.
Set to FALSE by default.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
Retrieves metadata associated with the most recent contributions by a
specified user.
}
\examples{

#Retrieve the timestamps of a user's recent contributions to the English-language Wikipedia
contribs <- user_contributions("en", "wikipedia", username = "Ironholds",
                              properties = "timestamp")

#Retrieve the timestamps of a user's recent contributions to a non-Wikimedia wiki.
rw_contribs <- user_contributions(domain = "rationalwiki.org", username = "David Gerard",
                                 properties = "ids", limit = 1)
                           
}
\seealso{
\code{\link{user_information}} for information about a specific user (or group of users),
and \code{recent_changes} for non-user-specific recent actions.
}
