% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_wblr.R
\name{plotly_wblr}
\alias{plotly_wblr}
\title{Interactive Probability Plot.}
\usage{
plotly_wblr(
  wblr_obj,
  susp = NULL,
  showConf = NULL,
  showSusp = NULL,
  showRes = NULL,
  showGrid = NULL,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  probCol = NULL,
  fitCol = NULL,
  confCol = NULL,
  intCol = NULL,
  gridCol = NULL,
  signif = NULL
)
}
\arguments{
\item{wblr_obj}{An object of class 'wblr'.}

\item{susp}{An optional numeric vector of suspension data.}

\item{showConf}{Show the confidence bounds (TRUE) or not (FALSE).}

\item{showSusp}{Show the suspensions plot (TRUE) or not (FALSE).}

\item{showRes}{Show the results table (TRUE) or not (FALSE).}

\item{showGrid}{Show grid (TRUE) or hide grid (FALSE).}

\item{main}{Main title.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{probCol}{Color of the probability values.}

\item{fitCol}{Color of the model fit.}

\item{confCol}{Color of the confidence bounds.}

\item{intCol}{Color of the intervals for interval censored models.}

\item{gridCol}{Color of the grid.}

\item{signif}{Significant digits of results}
}
\value{
The function returns no value.
}
\description{
Interactive Probability Plot.
}
\examples{
library(WeibullR)
library(WeibullR.plotly)
failures<-c(30, 49, 82, 90, 96)
obj<-wblr.conf(wblr.fit(wblr(failures)))
plotly_wblr(obj)
}
