% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LiftCurve.R
\name{LiftCurvePlotList}
\alias{LiftCurvePlotList}
\alias{LiftCurveListPlot}
\title{Plot the cumulative lift curves of a sort-order.}
\usage{
LiftCurvePlotList(
  frame,
  xvars,
  truthVar,
  title,
  ...,
  truth_target = NULL,
  palette = "Dark2"
)

LiftCurveListPlot(
  frame,
  xvars,
  truthVar,
  title,
  ...,
  truth_target = NULL,
  palette = "Dark2"
)
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvars}{name of the independent (input or model score) columns in frame}

\item{truthVar}{name of the dependent (output or result to be modeled) column in frame}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{truth_target}{if not NULL compare to this scalar value.}

\item{palette}{color palette for the model curves}
}
\description{
Plot the cumulative lift curves of a sort-order.
}
\details{
The use case for this visualization is to compare a predictive model
score to an actual outcome (either binary (0/1) or continuous). In this case the
lift curve plot measures how well the model score sorts the data compared
to the true outcome value.

The x-axis represents the fraction of items seen when sorted by score, and the
y-axis represents the lift seen so far (cumulative value of model over cummulative value of random selection)..
}
\examples{

set.seed(34903490)
y = abs(rnorm(20)) + 0.1
x = abs(y + 0.5*rnorm(20))
frm = data.frame(model=x, value=y)
WVPlots::LiftCurvePlotList(frm, c("model", "value"), "value",
   title="Example Continuous Lift Curves")

}
