% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-options.R
\name{vicmap_options}
\alias{vicmap_options}
\alias{check_chunk_limit}
\title{options}
\usage{
vicmap_options()

check_chunk_limit()
}
\value{
vicmap_options() returns a \code{data.frame}
}
\description{
This function retrieves bcdata specific options that can be set. These options can be set
using \verb{option(\{name of the option\} = \{value of the option\})}. The default options are purposefully
set conservatively to hopefully ensure successful requests. Resetting these options may result in
failed calls to the data catalogue. Options in R are reset every time R is re-started.

\code{vicmap.max_geom_pred_size} is the maximum size of an object used for a geometric operation. Objects
that are bigger than this value will be simplified in the request call using sf::st_simplify().
This is done to reduce the size of the query being sent to the WFS geoserver.

\code{vicmap.chunk_limit} is an option useful when dealing with very large data sets. When requesting large objects
from the catalogue, the request is broken up into smaller chunks which are then recombined after they've
been downloaded. VicmapR does this all for you but using this option you can set the size of the chunk
requested. On faster internet connections, a bigger chunk limit could be useful while on slower connections,
it is advisable to lower the chunk limit. Chunks must be less than 70000.

\code{vicmap.base_url} is the base wfs url used to query the geoserver.
}
\examples{
vicmap_options()
}
