library(VarReg)
context("checking semiVarReg and seVarReg and plotVarReg functions")
data(lidar)
test_that("Checking linear mean & variance model", {
  linmodel<-semiVarReg(lidar$logratio, lidar$range, meanmodel="linear", varmodel="linear")
  expect_equal_to_reference(linmodel, "SemiModel1.rds")
  linse<-seVarReg(linmodel, boot=TRUE, bootreps=10, maxit=100)
  linse2<-seVarReg(linmodel, boot=FALSE)
  expect_equal_to_reference(linse, "se1.rds")
  expect_equal_to_reference(linse2, "se2.rds")
  plotVarReg(linmodel, ci=FALSE)
  plotVarReg(linmodel, ci=TRUE)
  plotVarReg(linmodel, ci=TRUE, ci.type = "boot", bootreps = 10, maxit=100)
})
test_that("Checking con mean model", {
  conmeanmodel<-semiVarReg(lidar$logratio, lidar$range, meanmodel="constant", varmodel="semi", knots.v=2)
  expect_equal_to_reference(conmeanmodel, "SemiModel2.rds")
  conmeanse<-seVarReg(x=conmeanmodel, boot=TRUE, bootreps=5, maxit=100)
  expect_equal_to_reference(conmeanse, "se3.rds")
  plotVarReg(conmeanmodel, ci=TRUE, maxit=100)
  plotVarReg(x=conmeanmodel, ci=TRUE, ci.type = "boot", bootreps = 10, maxit=100)
})
test_that("Checking zero mean model", {
  zeromeanmodel<-semiVarReg(lidar$logratio, lidar$range, meanmodel="zero", varmodel="semi", knots.v=2)
  expect_equal_to_reference(zeromeanmodel, "SemiModel3.rds")
  zeromeanse<-seVarReg(zeromeanmodel, boot=TRUE, bootreps=5)
  expect_equal_to_reference(zeromeanse, "se4.rds")
  plotVarReg(x=zeromeanmodel, ci=FALSE)
  plotVarReg(x=zeromeanmodel, ci=TRUE, ci.type = "im")
  plotVarReg(x=zeromeanmodel, ci=TRUE, ci.type = "boot", bootreps = 10, maxit=100)
})
test_that("Checking knots in both  model", {
  semimodel<-semiVarReg(lidar$logratio, lidar$range, meanmodel="semi", varmodel="semi", knots.m=3, knots.v=2)
  expect_equal_to_reference(semimodel, "SemiModel4.rds")
  semise<-seVarReg(semimodel, boot=TRUE, bootreps=5)
  expect_equal_to_reference(semise, "se5.rds")
  seq1=seq(min(lidar$range), max(lidar$range), by=(max(lidar$range)-min(lidar$range))/999)
  seq2=seq(min(lidar$range), max(lidar$range), by=(max(lidar$range)-min(lidar$range))/9999)
  semise2<-seVarReg(semimodel, boot=TRUE, bootreps=10, maxit=100, vector.mean = seq1, vector.variance = seq2)
  expect_equal_to_reference(semise2, "se42.rds")
})
test_that("Checking con var  model", {
  convarmodel<-semiVarReg(lidar$logratio, lidar$range, meanmodel="semi", varmodel="constant", knots.m=3, knots.v=2)
  expect_equal_to_reference(convarmodel, "SemiModel5.rds")
  convarse<-seVarReg(convarmodel, boot=TRUE, bootreps=5)
  expect_equal_to_reference(convarse, "se6.rds")
  plotVarReg(x=convarmodel, ci=FALSE, ci.type = "boot", bootreps = 10, maxit=100)
  plotVarReg(x=convarmodel, ci=TRUE, ci.type = "im")
  plotVarReg(x=convarmodel, ci=TRUE, ci.type = "boot", bootreps = 10, maxit=100)
})
test_that("Checking monotonic variance=inc", {
  inc<-semiVarReg(lidar$logratio, lidar$range, meanmodel="semi", varmodel="semi", knots.m=3, knots.v=2, mono.var="inc")
  expect_equal_to_reference(inc, "SemiModel6.rds")
  incse<-seVarReg(x=inc, boot=TRUE, bootreps=5)
  expect_equal_to_reference(incse, "se7.rds")
})
test_that("Checking monotonic variance=dec", {
  dec<-semiVarReg(lidar$logratio, lidar$range, meanmodel="semi", varmodel="semi", knots.m=3, knots.v=2, mono.var="dec")
  expect_equal_to_reference(dec, "SemiModel7.rds")
  decse<-seVarReg(dec, boot=TRUE, bootreps=5)
  expect_equal_to_reference(decse, "se8.rds")

})