% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checking.R
\name{check_msg_time}
\alias{check_msg_time}
\title{Check the time value(s) at a specific message}
\usage{
check_msg_time(data, Msg = NULL, ReturnData = FALSE)
}
\arguments{
\item{data}{A data table object output by \code{\link{relabel_na}},
\code{\link{align_msg}}, or \code{\link{create_time_series}}.}

\item{Msg}{A character string containing the exact message to be found in 
the column SAMPLE_MESSAGE or a regular expression for locating the 
appropriate message.}

\item{ReturnData}{A logical indicating whether to return a data table 
containing Message Time information for each event.}
}
\value{
The value(s) of Time (in milliseconds) at which the Sample Message
is found.
}
\description{
\code{check_msg_time} examines the time point of a specific Sample Message
for each event. Depending on the format of the data, it will use one of three
columns: TIMESTAMP, Align, or Time.
}
\examples{
\dontrun{
library(VWPre)
# Check the Sample Message time...
check_msg_time(data = dat)
}
}
