% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{read_veg_classic}
\alias{read_veg_classic}
\title{Read the classic VIC vegetation parameter file.}
\usage{
read_veg_classic(vegfile, rootbands = 3, hasLAI = FALSE, hasFCAN = FALSE,
  hasALB = FALSE)
}
\arguments{
\item{vegfile}{Path of the vegetation parameter file.}

\item{rootbands}{Number of root bands.}

\item{hasLAI}{If the file includes LAI data.}

\item{hasFCAN}{If the file includes fcanopy data.}

\item{hasALB}{If the file includes albedo data.}
}
\value{
The vegetation parameter input (A list) for the run of
VIC model in this package.
}
\description{
Read the ASCII vegetation parameter file
of the classic VIC model
}
\details{
The detail of the vegetation parameter file of the classic VIC please
see \url{http://vic.readthedocs.io/en/master/Documentation/Drivers/Classic/VegParam/}
for the VIC official documentation. Here is an example of the vegetation
file of Two vegetation tiles with three root zones in the seventh grid
cell with LAI data.

\preformatted{
}
}

