% Generated by roxygen2 (4.0.2): do not edit by hand
\name{analyse_randomKde2d_AutoCalibrated}
\alias{analyse_randomKde2d_AutoCalibrated}
\title{Perform analysis of random 2d distributions (auto calibrated)}
\usage{
analyse_randomKde2d_AutoCalibrated(nstars, maxX, maxY, nKde=50, maxIter=40,
                                          showStats=FALSE, returnStats=TRUE)
}
\arguments{
\item{nstars}{an integer with the number of stars to consider}

\item{maxX}{the length of the field in X}

\item{maxY}{the length of the field in Y}

\item{nKde}{the number of samplings of the kernel in each direction}

\item{maxIter}{an integer with the maximum number of iterations}

\item{showStats}{a boolean indicating if the user wants to see statistics}

\item{returnStats}{a boolean indicating if the user wants statistics to be returned}
}
\value{
A data frame with the \code{mean} and \code{sd} fields containing the results
of the random field analysis.
}
\description{
The experimental code \code{analyse_randomKde2d_AutoCalibrated}
computes statistics from uniformly randomly created 2D fields based on kernel density
estimations (using \code{\link{create_randomKde2d}}). It runs for as many
interations as necessary for the statistical measuremnt stabilize (but it will abort
after \code{maxIter} iterations is reached).
}
\examples{
# Runs the analysis on random fields
toyRes <- analyse_randomKde2d_AutoCalibrated(100, 100, 100, 100, showStats=TRUE)

# Clean the environment
rm(toyRes)
}
\author{
Alberto Krone-Martins, Andre Moitinho
}
\keyword{utilities}

