% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TETSestim.R
\name{TETSestim}
\alias{TETSestim}
\title{TETSestim}
\usage{
TETSestim(m)
}
\arguments{
\item{m}{an object of type \code{TETS} created with \code{TETSforecast}}
}
\value{
The same input object with the appropriate fields 
filled in, in particular:
\item{p}{Estimated parameters}
\item{yFor}{Forecasted values of output}
\item{yForV}{Variance of forecasted values of output}
\item{ySimul}{Bootstrap simulations for forecasting distribution evaluation}
}
\description{
Estimates and forecasts TOBIT TETS models
}
\details{
\code{TETSestim} estimates and forecasts a time series using an
a TOBIT TETS model
}
\examples{
\dontrun{
m1 <- TETSsetup(log(gdp))
m1 <- TETSestim(m1)
}
}
\seealso{
\code{\link{TETS}}, \code{\link{TETSforecast}}, \code{\link{TETSvalidate}},
         \code{\link{TETScomponents}}
}
\author{
Diego J. Pedregal
}
