% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XenaDownload.R
\name{XenaDownload}
\alias{XenaDownload}
\title{Download Datasets from UCSC Xena Hubs}
\usage{
XenaDownload(xquery, destdir = tempdir(), download_probeMap = FALSE,
  trans_slash = FALSE, force = FALSE, ...)
}
\arguments{
\item{xquery}{a tibble object generated by \link{XenaQuery} function.}

\item{destdir}{specify a location to store download data. Default is system temp directory.}

\item{download_probeMap}{if \code{TRUE}, also download ProbeMap data, which used for id mapping.}

\item{trans_slash}{logical, default is \code{FALSE}. If \code{TRUE}, transform slash '/' in dataset id
to '__'. This option is for backwards compatibility.}

\item{force}{logical. if \code{TRUE}, force to download data no matter whether files exist.
Default is \code{FALSE}.}

\item{...}{other argument to \code{download.file} function}
}
\value{
a \code{tibble}
}
\description{
Avaliable datasets list: \url{https://xenabrowser.net/datapages/}
}
\examples{
\donttest{
xe = XenaGenerate(subset = XenaHostNames == "tcgaHub")
hosts(xe)
xe_query = XenaQuery(xe)
xe_download = XenaDownload(xe_query)
}
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
