% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_2rm__main.R
\name{fit_2rm}
\alias{fit_2rm}
\alias{is.TwoRegression}
\title{Develop a two-regression algorithm}
\usage{
fit_2rm(
  data,
  activity_var,
  sed_cp_activities,
  sed_activities,
  sed_cp_var,
  sed_METs,
  walkrun_activities,
  walkrun_cp_var,
  met_var,
  walkrun_formula,
  intermittent_formula,
  method = "user_unspecified"
)

is.TwoRegression(x)
}
\arguments{
\item{data}{The data with which to develop the algorithm}

\item{activity_var}{Character scalar. Name of the variable defining which
activity is being performed}

\item{sed_cp_activities}{Character vector. Activities to be included in the
process of forming the sedentary classifier}

\item{sed_activities}{Character vector. Actual sedentary activities}

\item{sed_cp_var}{Character scalar. Name of the variable on which the
sedentary cut-point is defined}

\item{sed_METs}{Numeric scalar. Metabolic equivalent value to apply to
sedentary activities}

\item{walkrun_activities}{Character vector. Actual ambulatory activities}

\item{walkrun_cp_var}{Character scalar. Name of the variable on which the
walk/run cut-point is defined}

\item{met_var}{Character scalar. Name of the variable giving actual energy
expenditure (in metabolic equivalents)}

\item{walkrun_formula}{Character scalar. Formula to use for developing the
walk/run regression model}

\item{intermittent_formula}{Character scalar. Formula to use for developing the
intermittent activity regression model}

\item{method}{character scalar. Optional name for the model, potentially
useful for printing.}

\item{x}{object to be tested}
}
\value{
An object of class `TwoRegression`
}
\description{
Develop a two-regression algorithm

Check if an object has class TwoRegression
}
\examples{

set.seed(307)

data(all_data, package = "TwoRegression")
fake_sed <- c("Lying", "Sitting")
fake_lpa <- c("Sweeping", "Dusting")
fake_cwr <- c("Walking", "Running")
fake_ila <- c("Tennis", "Basketball")

fake_activities <- c(fake_sed, fake_lpa, fake_cwr, fake_ila)

all_data$Activity <- sample(fake_activities, nrow(all_data), TRUE)

all_data$fake_METs <- ifelse(
  all_data$Activity \%in\% c(fake_sed, fake_lpa),
  runif(nrow(all_data), 1, 2),
  runif(nrow(all_data), 2.5, 8)
)

fit_2rm(
  data = all_data,
  activity_var = "Activity",
  sed_cp_activities = c(fake_sed, fake_lpa),
  sed_activities = fake_sed,
  sed_cp_var = "ENMO",
  sed_METs = 1.25,
  walkrun_activities = fake_cwr,
  walkrun_cp_var = "ENMO_CV10s",
  met_var = "fake_METs",
  walkrun_formula = "fake_METs ~ ENMO",
  intermittent_formula = "fake_METs ~ ENMO + I(ENMO^2) + I(ENMO^3)"
)
}
\seealso{
\code{\link{predict.TwoRegression}}
\code{\link{summary.TwoRegression}}
\code{\link{plot.TwoRegression}}
}
