% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R, R/binomial.R, R/chisq.R,
%   R/contbernoulli.R, R/exponential.R, R/gamma.R, R/genericFunctions.R,
%   R/inverse-gamma.R, R/inverse-gaussian.R, R/log-normal.R,
%   R/negative-binomial.R, R/normal.R, R/poisson.R
\name{dtruncbeta}
\alias{dtruncbeta}
\alias{dtruncbinom}
\alias{dtruncchisq}
\alias{dtrunccontbern}
\alias{dtruncexp}
\alias{dtruncgamma}
\alias{dtrunc}
\alias{dtruncinvgamma}
\alias{dtruncinvgauss}
\alias{dtrunclnorm}
\alias{dtrunc.trunc_nbinom}
\alias{dtruncnbinom}
\alias{dtruncnorm}
\alias{dtruncpois}
\title{Probability Density Function}
\usage{
dtruncbeta(y, shape1, shape2, eta, a = 0, b = 1, ...)

dtruncbinom(y, size, prob, eta, a = 0, b = attr(y, "parameters")$size, ...)

dtruncchisq(y, df, eta, a = 0, b = Inf, ...)

dtrunccontbern(y, lambda, eta, a = 0, b = 1, ...)

dtrunccontbern(y, lambda, eta, a = 0, b = 1, ...)

dtruncexp(y, rate = 1, eta, a = 0, b = Inf, ...)

dtruncgamma(y, shape, rate = 1, scale = 1/rate, eta, a = 0, b = Inf, ...)

dtrunc(y, ...)

dtruncinvgamma(y, shape, rate = 1, scale = 1/rate, eta, a = 0, b = Inf, ...)

dtruncinvgauss(y, m, s, eta, a = 0, b = Inf, ...)

dtrunclnorm(y, meanlog = 0, sdlog = 1, eta, a = 0, b = Inf, ...)

\method{dtrunc}{trunc_nbinom}(y, size, prob, eta, a = 0, b = Inf, ...)

dtruncnbinom(y, size, prob, eta, a = 0, b = Inf, ...)

dtruncnbinom(y, size, prob, eta, a = 0, b = Inf, ...)

dtruncnorm(y, mean = 0, sd = 1, eta, a = -Inf, b = Inf, ...)

dtruncpois(y, lambda, eta, a = 0, b = Inf, ...)
}
\arguments{
\item{y}{output from rtrunc or any valid numeric value(s).}

\item{shape1}{positive shape parameter alpha}

\item{shape2}{positive shape parameter beta}

\item{eta}{vector of natural parameters}

\item{a}{point of left truncation}

\item{b}{point of right truncation}

\item{...}{size}

\item{size}{target for number of successful trials,
or dispersion parameter (the shape parameter of the gamma mixing
distribution). Must be strictly positive, need not be integer.}

\item{prob}{probability of success on each trial}

\item{df}{degrees of freedom for "parent" distribution}

\item{lambda}{mean and var of "parent" distribution}

\item{rate}{inverse gamma rate parameter}

\item{shape}{inverse gamma shape parameter}

\item{scale}{inverse gamma scale parameter}

\item{m}{vector of means}

\item{s}{vector of dispersion parameters}

\item{meanlog}{mean of un-truncated distribution}

\item{sdlog}{standard deviation of un-truncated distribution}

\item{mean}{mean of parent distribution}

\item{sd}{standard deviation is parent distribution}
}
\value{
The density of y for the given values of the \code{eta} parameter.
}
\description{
Calculates the PDF for a given truncated distribution
}
\note{
Either the common or the natural parameters must be provided.
}
\examples{
# Using the output of rtrunc
y <- rtrunc(50, mean = 5, sd = 2)
dtrunc(y, eta = c(0, -1))

# Directly-inputting values
dtruncnorm(y = c(5, 0, -10), eta = c(0, -0.05))
}
