% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_dtrunc.R, R/beta.R, R/binomial.R, R/chisq.R,
%   R/contbernoulli.R, R/exponential.R, R/gamma.R, R/inverse-gamma.R,
%   R/inverse-gaussian.R, R/log-normal.R, R/negative-binomial.R, R/normal.R,
%   R/poisson.R
\name{dtrunc}
\alias{dtrunc}
\alias{dtruncbeta}
\alias{dtruncbinom}
\alias{dtruncchisq}
\alias{dtrunccontbern}
\alias{dtruncexp}
\alias{dtruncgamma}
\alias{dtruncinvgamma}
\alias{dtruncinvgauss}
\alias{dtrunclnorm}
\alias{dtruncnbinom}
\alias{dtruncnorm}
\alias{dtruncpois}
\title{Probability Density Function}
\usage{
dtrunc(y, eta, a, b)

dtruncbeta(y, eta, a = 0, b = 1)

dtruncbinom(y, eta, a = 0, b = attr(y, "parameters")$size, ...)

dtruncchisq(y, eta, a = 0, b = Inf)

dtrunccontbern(y, eta, a = 0, b = 1)

dtruncexp(y, eta, a = 0, b = Inf)

dtruncgamma(y, eta, a = 0, b = Inf)

dtruncinvgamma(y, eta, a = 0, b = Inf)

dtruncinvgauss(y, eta, a = 0, b = Inf)

dtrunclnorm(y, eta, a = 0, b = Inf)

dtruncnbinom(y, eta, a = 0, b = Inf, ...)

dtruncnorm(y, eta, a = -Inf, b = Inf)

dtruncpois(y, eta, a = 0, b = Inf)
}
\arguments{
\item{y}{output from rtrunc or any valid numeric value(s).}

\item{eta}{Natural parameters}

\item{a}{lower truncation limit}

\item{b}{upper truncation limit}

\item{...}{size}
}
\value{
The density of y for the given values of the \code{eta} parameter.
}
\description{
Calculates the PDF for a given truncated distribution
}
\examples{
# Using the output of rtrunc
y <- rtrunc(50, mean = 5, sd = 2)
dtrunc(y, eta = c(0, -1))

# Directly-inputting values
dtruncnorm(y = c(5, 0, -10), eta = c(0, -0.05))
}
