% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Z_BevertonHolt.R
\name{Z_BevertonHolt}
\alias{Z_BevertonHolt}
\title{Beverton & Holt's Z-Equations}
\usage{
Z_BevertonHolt(param, catch_columns = NA, Lprime_tprime)
}
\arguments{
\item{param}{a list consisting of following parameters:
\itemize{
  \item  \code{midLengths} or \code{age}: midpoints of length groups
  (length-frequency data) or ages (age composition data),
  \item \code{Linf}: infinite length for investigated species in cm [cm],
  \item \code{K}: growth coefficent for investigated species per year [1/year],
  \item \code{t0}: theoretical time zero, at which individuals of this species hatch,
  \item \code{catch}: catch as vector, or a matrix with catches of subsequent years;
}}

\item{catch_columns}{optional; in case catch is a matrix or data.frame, a number or vector
indicating which column(s) of the matrix should be analysed (Default: \code{NA}).}

\item{Lprime_tprime}{length or age prime, above which all fish are under full exploitation as
mid length or age class.}
}
\value{
A list with the input parameters and following objects:
\itemize{
  \item \strong{tmean} or \strong{Lmean}: mean age or length of fish,
  \item \strong{tprime} or \strong{Lprime}: some age or length for which all fish of
     that length and longer are under full exploitation,
  \item \strong{Z}: total mortality.
}
}
\description{
A method to estimate the instantaneous total mortality rate (Z) based
   on a method derived by Beverton and Holt (1956).
}
\details{
The first length group or age class within the list object \code{midLengths} or
   \code{age} will be used as the Lprim or tprime (length of recruitment to fishery).
}
\examples{
# based on length-frequency data
data(synLFQ2)
Z_BevertonHolt(synLFQ2, catch_columns = 2, Lprime_tprime = 47.5)

# based on age composition data
data(synCAA1)
Z_BevertonHolt(synCAA1, catch_columns = 3, Lprime_tprime = 2.5)

}
\references{
Beverton R.J.H and S.J. Holt, 1956. A review of methods of estimating mortality rates
in exploited fish populations, with special reference to sources of bias in catch
sampling. \emph{Rapp.P.-v.Reun.CIEM}, 140:67-83

Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2). 407 p.
}
\keyword{Z}
\keyword{function}
\keyword{mortality}
