#' @name synLFQ4
#'
#' @title Synthetic length-frequency data IV (with seasonal oscillation)
#'
#'
#' @description Synthetic length-frequency data as generated by the function
#' \code{lfqGen} from the \emph{fishdynr} package (Taylor 2016). Can be used by
#' \code{\link[TropFishR]{ELEFAN}} or \code{\link[TropFishR]{ELEFAN_SA}}.
#' The data is generated with the following von Bertalanffy growth parameters:
#' \itemize{
#'   \item K = 0.5
#'   \item Linf = 80
#'   \item C = 0.75
#'   \item ts = 0.5
#'   \item t_anchor = 0.25 (Time when yearly recruitment pulse occurs;
#'   e.g. 0 = Jan 1, 0.25 = Apr 1, 0.5 = Jul 1st, 0.75 = Oct 1)
#' }
#'
#' Further settings include:
#' \itemize{
#'   \item Linf.cv = 0.05
#'   \item K.cv = 0.05
#'   \item L50 = 20 (length at 50\% prob. of capture via trawl net)
#'   \item wqs = 0 (width between 25\% and 75\% prob. of capture quantiles;
#'   i.e. wqs = 0 is knife-edge selection)
#'   \item M = 0.5 (Natural mortality rate)
#'   \item harvest_rate = 0.5 (Fishing mortality rate)
#' }
#'
#' @docType data
#'
#' @format A list of class lfq consisting of:
#' \itemize{
#'   \item \strong{dates} dates of sampling times (class Date),
#'   \item \strong{midLengths} midpoints of the length classes,
#'   \item \strong{catch} matrix with catches/counts per length class (row) and sampling date (column).
#' }
#'
#' @source Taylor, M (2016). fishdynr: Fisheries science related population dynamics
#' models. R package version 0.2. https://github.com/marchtaylor/fishdynr
#'
#' @usage data(synLFQ4)
#' @keywords data dataset length-frequency
#'
#' @examples
#' data(synLFQ4)
#'
#' # plot of length frequencies
#' plot(synLFQ4, Fname = "catch")
#'
#' # plot of restructured length frequencies
#' synLFQ4 <- lfqRestructure(synLFQ4, MA = 15)
#' plot(synLFQ4, Fname = "rcounts")
#'
#'
#'
NULL
