% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_files.R
\name{PhyToString}
\alias{PhyToString}
\alias{PhyDatToString}
\alias{PhydatToString}
\title{phyDat to String}
\usage{
PhyToString(phy, parentheses = "{", collapse = "", ps = "",
  useIndex = TRUE, byTaxon = TRUE, concatenate = TRUE)

PhyDatToString(phy, parentheses = "{", collapse = "", ps = "",
  useIndex = TRUE, byTaxon = TRUE, concatenate = TRUE)

PhydatToString(phy, parentheses = "{", collapse = "", ps = "",
  useIndex = TRUE, byTaxon = TRUE, concatenate = TRUE)
}
\arguments{
\item{phy}{An object of class \code{\link{phyDat}}}

\item{parentheses}{Character specifying format of parentheses with which
to surround ambiguous tokens.  Choose from: \code{\{} (default), \code{[}, \code{(}, \code{<}.}

\item{collapse}{Character specifying text, perhaps \code{,}, with which to
separate multiple tokens within parentheses}

\item{ps}{Character specifying text, perhaps \code{;}, to append to the end of the string}

\item{useIndex}{Logical (default: \code{TRUE}) specifying whether to print
duplicate characters multiple times, as they appeared in the original matrix}

\item{byTaxon}{Logical. If \code{TRUE}, write one taxon followed by the next.
If \code{FALSE}, write one character followed by the next.}

\item{concatenate}{Logical specifying whether to concatenate all characters/taxa
into a single string, or to return a separate string
for each entry.}
}
\value{
\code{PhyToString} returns a character vector listing a text
representation of the phylogenetic character state for each taxon in turn.
}
\description{
Extract character data from a phyDat object as a string.
}
\examples{
fileName <- paste0(system.file(package='TreeTools'),
                   '/extdata/input/dataset.nex')
phyDat <- ReadAsPhyDat(fileName)
PhyToString(phyDat, concatenate = FALSE)

}
\seealso{
\itemize{
\item \code{\link{StringToPhyDat}}
}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
