% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_dim.R
\name{compute.stats}
\alias{compute.stats}
\title{Tree Dimension Test Related Statistics}
\usage{
compute.stats(x, MST = c("boruvka", "exact"), dim.reduction = c("pca", "none"))
}
\arguments{
\item{x}{matrix of input data. Rows as observations and columns as features}

\item{MST}{name of MST to be used in test. There are 2 options; "exact" MST and "boruvka" which is faster for large samples}

\item{dim.reduction}{string parameter with value "pca" to perform dimensionality reduction or "none" to not perform dimensionality reduction}
}
\value{
A list with the following components:
\itemize{
 \item tdt_measure The tree dimension value for the given input data
 \item tdt_effect Effect size for tree dimension
 \item leaves Number of leaf/degree1 vertices in the MST  of the data
 \item diameter The tree diameter of MST, where each edge is of unit length
 }
}
\description{
Computes tree dimension measure, tree dimension test effect,
number leafs and tree diameter from MST of a given dataset
}
