% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_Rao_Blackwell.R
\name{BayesFactorMPT}
\alias{BayesFactorMPT}
\title{Bayes Factors for Simple (Nonhierarchical) MPT Models}
\usage{
BayesFactorMPT(models, resample = 10000, scale = 0.1, batches = 10,
  store = FALSE, nCPU = 1)
}
\arguments{
\item{models}{list of models fitted with \code{\link{simpleMPT}}, e.g., \code{list(mod1, mod2)}}

\item{resample}{how much parameter posterior samples should be resampled per model}

\item{scale}{scaling factor for the posterior approximation of the posterior samples}

\item{batches}{number of batches to compute standard error}

\item{store}{whether to save parameter samples}

\item{nCPU}{number of CPUs used}
}
\description{
Computes Bayes factors for simple (fixed-effects, nonhierarchical) MPT models with beta distributions as priors on the parameters.
}
\details{
Currently, this is only implemented for a single data set!

Uses a Rao-Blackwellized version of the product-space method (Carlin & Chib, 1995) as proposed by Barker and Link (2013). First, posterior distributions of the MPT parameters are approximated by independent beta distributions. Second, for one a selected model, parameters are sampled from these proposal distributions. Third, the conditional probabilities to switch to a different model are computed and stored. Finally, the eigenvector with eigenvalue one of the matrix of switching probabilities provides an estimate of the posterior model probabilities.
}
\references{
Barker, R. J., & Link, W. A. (2013). Bayesian multimodel inference by RJMCMC: A Gibbs sampling approach. The American Statistician, 67(3), 150-156.

Carlin, B. P., & Chib, S. (1995). Bayesian model choice via Markov chain Monte Carlo methods. Journal of the Royal Statistical Society. Series B (Methodological), 57(3), 473-484.
}
\seealso{
\code{\link{marginalMPT}}
}
