% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genDataMPT.R
\name{genMPT}
\alias{genMPT}
\title{Generate MPT Frequencies}
\usage{
genMPT(theta, numItems, eqnfile)
}
\arguments{
\item{theta}{matrix of MPT parameters (rows: individuals; columns: parameters). Parameters are assigned by column names of the matrix. all of the parameters in the model file need to be included.}

\item{numItems}{number of responses per tree (a named vector with tree labels)}

\item{eqnfile}{path to EQN file specifying the MPT model}
}
\description{
Uses a matrix of individual MPT parameters to generate MPT frequencies.
}
\examples{
# Example: Standard Two-High-Threshold Model (2HTM)
EQNfile <- system.file("MPTmodels/2htm.eqn", package="TreeBUGS")
theta <- matrix(c(.8,.4,.5, .6,.3,.4),
                nrow=2, byrow=TRUE,
                dimnames=list(NULL, c("Do","Dn","g")))
genDat <- genMPT(theta, c(Target=250, Lure=250),
                EQNfile)
genDat
}
\seealso{
\code{\link{genTraitMPT}} and \code{\link{genBetaMPT}} to generate data for latent normal/beta hierarchical distributions.
}

