% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FX.R
\name{FxSwap-class}
\alias{FxSwap-class}
\alias{FxSwap}
\title{Fx Swap Class}
\arguments{
\item{Notional}{The notional amount of the trade}

\item{MTM}{The mark-to-market valuation of the trade}

\item{Currency}{The currency that the input amounts are in}

\item{ccyPair}{The currency Pair of the trade}

\item{Si}{The number of years that the trade will take to start (zero if already started)}

\item{Ei}{The number of years that the trade will expire}

\item{BuySell}{Takes the values of either 'Buy' or 'Sell'}

\item{traded_price}{the price that trade was done}

\item{fx_near_leg_fields}{(Optional) In case the near leg hasn't settled yet, its notional, MtM, settlement date should be provided separated via a semicolon}
}
\value{
An object of type FXSwap
}
\description{
Creates an FX Swap object with the relevant info needed to calculate the Exposure-at-Default (EAD)
}

\examples{


tr1 = FxSwap(Notional=10000,MtM=30,ccyPair="EUR/USD",Si=0,Ei=10,
BuySell='Buy',fx_near_leg_fields='1000;-20;2020-02-11')
}
\references{
Basel Committee: The standardised approach for measuring counterparty credit risk exposures
http://www.bis.org/publ/bcbs279.htm
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
