% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/martingale_strategy_calculator.R
\name{martingale_strategy_repetitions}
\alias{martingale_strategy_repetitions}
\title{Martingale Strategy Repetitions}
\usage{
martingale_strategy_repetitions(
  length_of_targeted_sequence,
  prob_of_success = 18/37,
  simulations_num,
  trials_per_sim,
  quantile_perc
)
}
\arguments{
\item{length_of_targeted_sequence}{The number of consecutive failed trades/bets that we try to calculate the expected number of repetitions for}

\item{prob_of_success}{The probability of a sucessful trade/bet}

\item{simulations_num}{The number of simulations to be run}

\item{trials_per_sim}{The number of trials in each simulation}

\item{quantile_perc}{(Optional) When set, the number of repetitions expected with such probability is returned.}
}
\value{
A list containing the number of repetitions needed to reach the targeted sequence for the first time in each simulation 
(will be zero if the sequence is not found) and, when the quantile_perc is set, the above number of repetitions.
}
\description{
Calculates the number of repetitions needed for a specific number of consequtive failed trades/bet to appear. 
This can apply to roulette betting but also trading algorithms which use the same logic on doubling down after a failed trade.
}
\examples{

# This software is covered by GPL license and provided strictly for educational 
# reasons (no actual investment or betting decisions should be taken based on this)
# On top of these, the below example contains a tiny number of simulations and
# trials just to pass CRAN tests - the user would have to highly increase both
# variables when running these.
repetitions_for_failed_sequence = martingale_strategy_repetitions(length_of_targeted_sequence = 8,
prob_of_success = 18/37, simulations_num = 1000, trials_per_sim = 10000, quantile_perc = 0.1)
repetitions_for_failed_sequence$relevant_quantile
summary(repetitions_for_failed_sequence$num_of_trials_needed)

}
\references{
https://en.wikipedia.org/wiki/Roulette#Betting_strategies_and_tactics
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
