% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commodity.R
\docType{class}
\name{CommodityForward-class}

\alias{CommodityForward}
\title{Commodity Forward Class}
\arguments{
\item{Notional}{The notional amount of the trade}

\item{MTM}{The mark-to-market valuation of the trade}

\item{Currency}{The currency set that the trade belongs to}

\item{Si}{The number of years that the trade will take to start (zero if already started)}

\item{Ei}{The number of years that the trade will expire}

\item{BuySell}{Takes the values of either 'Buy' or 'Sell'}

\item{commodity_type}{Takes the values of 'Oil','Gas','Silver','Electricity' etc.}

\item{SubClass}{Defines the relevant hedging set. Possible values: 'Energy','Agriculture','Metal','Other','Climatic'}
}
\value{
An object of type Commodity Forward
}
\description{
Creates a Commodity Forward Object with the relevant info needed to calculate the Exposure-at-Default (EAD)
}

\examples{

## the Commodity Forward trade given in the Basel regulation Commodity example
tr1 = CommodityForward(Notional=10000,MtM=-50,Si=0,Ei=0.75,
BuySell='Buy',SubClass='Energy',commodity_type='Oil')
}
\references{
Regulation (EU) 2019/876 of the European Parliament and of the Council of 20 May 2019
http://data.europa.eu/eli/reg/2019/876/oj
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
