% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_bindings.R
\name{header_n}
\alias{header_n}
\alias{header_n<-}
\alias{set_header_n}
\title{Return or set header_n binding}
\usage{
header_n(table)

header_n(x) <- value

set_header_n(table, value)
}
\arguments{
\item{table}{A \code{tplyr_table} object}

\item{x}{A \code{tplyr_table} object}

\item{value}{A data.frame with columns with the treatment variable, column
variabes, and a variable with counts named 'n'.}

\item{header_n}{A data.frame with columns with the treatment variable, column
variabes, and a variable with counts named 'n'.}
}
\value{
For \code{tplyr_header_n} the header_n binding of the
  \code{tplyr_table} object. For \code{tplyr_header_n<-} and
  \code{set_tplyr_header_n} the modified object.
}
\description{
The `header_n()` functions can be used to automatically pull the header_n
derivations from the table or change them for future use.
}
\details{
The `header_n` object is created by Tplyr when a table is built and intended
to be used by the `add_column_headers()` function when displaying table level
population totals. These methods are intended to be used for calling the
population totals calculated by Tplyr, and to overwrite them if a user
chooses to.

If you have a need to change the header Ns that appear in your table headers,
say you know you are working with a subset of the data that doesn't represent
the totals, you can replace the data used with `set_header_n()`.
}
\examples{
tab <- tplyr_table(mtcars, gear)

header_n(tab) <- data.frame(
  gear = c(3, 4, 5),
  n = c(10, 15, 45)
)



}
