% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.stationary.test.R
\name{ts.stationary.test}
\alias{ts.stationary.test}
\title{Stationarity testing}
\usage{
ts.stationary.test(tsdata)
}
\arguments{
\item{tsdata}{The input univariate time series data}
}
\value{
A string indicating if the time series is stationary or non stationary for internal use in ts.analysis.
}
\description{
This functions tests the stationarity of the input time series data.
}
\details{
This function tests the deterministic and stochastic trend of the input time series data. This function uses ACF and PACF functions 
from forecast package, Phillips Perron test, Augmented Dickey Fuller (ADF) test, Kwiatkowski Phillips Schmidt Shin (KPSS) test,
from tseries package and Mann Kendall test for Monotonic Trend Cox Stuart trend test from trend package.

Phillips Perron test tests the null hypothesis of whether a unit root is present in a time series sample, 
against a stationary alternative. The truncation lag parameter is set to trunc(4*(n/100)^0.25), 
where n the length of the in input time series data

Augmented Dickey Fuller (ADF) test, tests the null hypothesis of whether a unit root is present in a time series sample.
The truncation lag parameter is set to trunc((n-1)^(1/3))), where n the length of the input time series data

Kwiatkowski Phillips Schmidt Shin (KPSS) test, tests a null hypothesis that an observable time series is stationary
around a deterministic trend (i.e. trend stationary) against the alternative of a unit root. 
The truncation lag parameter is set to trunc(3*sqrt(n)/13), where n the length of the input time series data

The non parametric Mann Kendall test is used to detect monotonic trends. The null hypothesis, H0, is that the data 
come from a population with independent realizations and are identically distributed. 
The alternative hypothesis, HA, is that the data follow a monotonic trend.

The Cox Stuart test is a modified sign test. The null hypothesis, H0, is that the input time series assumed to be independent
against the fact that there is a time dependent trend (monotonic trend).
}
\examples{
ts.stationary.test(Athens_approved_ts)

}
\references{
tseries, trend
}
\seealso{
\code{\link{ts.analysis}}, \code{\link[forecast]{Acf}}, \code{\link{Pacf}}, \code{\link[tseries]{pp.test}},
\code{\link[tseries]{adf.test}}, \code{\link[tseries]{kpss.test}}, \code{\link[trend]{mk.test}}, \code{\link[trend]{cs.test}}
}
\author{
Kleanthis Koupidis, Charalampos Bratsas
}
