% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{survival}
\alias{survival}
\title{Compute the Conditional Survival Function}
\usage{
survival(result, data)
}
\arguments{
\item{result}{S3 object of class 'AdPaik' containing model results.}

\item{data}{Data frame containing covariates used in the model.}
}
\value{
A dataset where each row corresponds to an individual unit in the dataset,
and the columns represent the survival function values over time interval,
with the first column indicating the cluster to which the individual belongs.
}
\description{
Computes the conditional survival function based on the 'Adapted Paik et al.' model's
given the estimated coefficients and frailty effects.
}
\examples{
# Import data
data(data_dropout)

# Define the variables needed for the model execution
eps_paik <- 1e-10
categories_range_min <- c(-8, -2, eps_paik, eps_paik, eps_paik)
categories_range_max <- c(-eps_paik, 0.4, 1 - eps_paik, 1, 10)
time_axis <- c(1.0, 1.4, 1.8, 2.3, 3.1, 3.8, 4.3, 5.0, 5.5, 5.8, 6.0)
formula <- time_to_event ~ Gender + CFUP + cluster(group)

# Call the main model function
\donttest{
result <- AdPaikModel(formula, data_dropout, time_axis, categories_range_min, categories_range_max)

survival_df = survival(result, data_dropout)
 }  
}
