% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random-tidy-triangular.R
\name{tidy_triangular}
\alias{tidy_triangular}
\title{Generate Tidy Data from Triangular Distribution}
\usage{
tidy_triangular(
  .n = 50,
  .min = 0,
  .max = 1,
  .mode = 1/2,
  .num_sims = 1,
  .return_tibble = TRUE
)
}
\arguments{
\item{.n}{The number of x values for each simulation.}

\item{.min}{The minimum value of the triangular distribution.}

\item{.max}{The maximum value of the triangular distribution.}

\item{.mode}{The mode (peak) value of the triangular distribution.}

\item{.num_sims}{The number of simulations to perform.}

\item{.return_tibble}{A logical value indicating whether to return the result
as a tibble. Default is TRUE.}
}
\value{
A tibble of randomly generated data.
}
\description{
This function generates tidy data from the triangular distribution.
}
\details{
The function takes parameters for the triangular distribution
(minimum, maximum, mode), the number of x values (\code{n}), the number of
simulations (\code{num_sims}), and an option to return the result as a tibble
(\code{return_tibble}). It performs various checks on the input parameters to ensure
validity. The result is a data frame or tibble with tidy data for
further analysis.
}
\examples{
tidy_triangular(.return_tibble = TRUE)

}
\seealso{
Other Continuous Distribution: 
\code{\link{tidy_beta}()},
\code{\link{tidy_burr}()},
\code{\link{tidy_cauchy}()},
\code{\link{tidy_chisquare}()},
\code{\link{tidy_exponential}()},
\code{\link{tidy_f}()},
\code{\link{tidy_gamma}()},
\code{\link{tidy_generalized_beta}()},
\code{\link{tidy_generalized_pareto}()},
\code{\link{tidy_geometric}()},
\code{\link{tidy_inverse_burr}()},
\code{\link{tidy_inverse_exponential}()},
\code{\link{tidy_inverse_gamma}()},
\code{\link{tidy_inverse_normal}()},
\code{\link{tidy_inverse_pareto}()},
\code{\link{tidy_inverse_weibull}()},
\code{\link{tidy_logistic}()},
\code{\link{tidy_lognormal}()},
\code{\link{tidy_normal}()},
\code{\link{tidy_paralogistic}()},
\code{\link{tidy_pareto1}()},
\code{\link{tidy_pareto}()},
\code{\link{tidy_t}()},
\code{\link{tidy_uniform}()},
\code{\link{tidy_weibull}()},
\code{\link{tidy_zero_truncated_geometric}()}

Other Triangular: 
\code{\link{util_triangular_param_estimate}()},
\code{\link{util_triangular_stats_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Continuous Distribution}
\concept{Triangular}
