% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_alphas.R
\name{optimal_alphas}
\alias{optimal_alphas}
\title{Title optimal alphas function}
\usage{
optimal_alphas(x, w, y, grid_alphas, cont_folds, family)
}
\arguments{
\item{x}{A matrix of variables to be selected by shrinkrage methods.}

\item{w}{A matrix or vector of variables that cannot be selected(no shrinkrage).}

\item{y}{response variable.}

\item{grid_alphas}{a grid of alphas between 0 and 1.}

\item{cont_folds}{Set TRUE for contiguous folds used in time depedent data.}

\item{family}{The glmnet family.}
}
\value{
lambdas_opt a vector with the optimal alpha and lambda.
}
\description{
Title optimal alphas function
}
\examples{

set.seed(1)
data("stock_data")
data("news_data")
y=as.matrix(stock_data[1:200,2])
w=as.matrix(stock_data[1:200,3])
data("news_data")
X=news_data[1:200,2:ncol(news_data)]
x=as.matrix(X)
grid_alphas=seq(by=0.25,to=1,from=0.5)
cont_folds=TRUE
t=length(y)
optimal_alphas=optimal_alphas(x[1:(t-1),],
w[1:(t-1),],y[2:t],grid_alphas,TRUE,"gaussian")

}
