% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomizingTree.R
\name{GetLayerSampleIndexes}
\alias{GetLayerSampleIndexes}
\title{GetLayerSampleIndexes}
\usage{
GetLayerSampleIndexes(section_vector, command_vector,
  sampleSectionOrder = FALSE, randomizeSection = TRUE)
}
\arguments{
\item{sampleSectionOrder}{Should it also move around the sections or not? Look at the details for a more detailed explanation}

\item{NamesOfListToSample}{The names of each element on the list we want to sample, with the original order. The usual use would be \code{NamesOfListToSample = names(list)}.

    Being specific, the names that are provided will be matched with the regular expression \code{"^[[:digit:]]+_.+[[:digit:]]+_"}.}

\item{isRandomized}{If this is set to false, it will not randomize the list, it will just output \code{1:length(OfNamesOfListToSample)}. It handles properly when the list is of length 0, by outputting \code{integer(0)}}
}
\value{
An integer vector, that would provide a random reordering of the list.
}
\description{
Function to randomize the names of a list to sample, as provided by \code{\link{StructureDocument}}. It takes the names of the list, not the list itself, and it provides the indexes needed to resample the original list judging by those names. It doesn't output a resampled list.
}
\details{
Following the prescription from \code{\link{StructureDocument}}, it keeps the "prior_to" and "post_to" parts fixed. And within each section it keeps the "begin_" and "end_" parts fixed. Then, it resamples everything within each section, and afterwards resamples the order of the sections if \code{sampleSectionOrder} is true

 Note how the names of the list are expected to represent the structure described in \code{\link{StructureDocument}}
}
\keyword{internal}
