% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow_class.R
\docType{class}
\name{config_Shadow-class}
\alias{config_Shadow-class}
\alias{createShadowTestConfig}
\title{createShadowTestConfig}
\usage{
createShadowTestConfig(item_selection = NULL, content_balancing = NULL,
  MIP = NULL, MCMC = NULL, refresh_policy = NULL,
  exposure_control = NULL, stopping_criterion = NULL,
  interim_theta = NULL, final_theta = NULL, theta_grid = seq(-4, 4,
  0.1), audit_trail = F)
}
\arguments{
\item{item_selection}{A list containing item selection criteria.
\itemize{
  \item{\code{method}} The type of criteria. Accepts one of \code{MFI, MPWI, FB, EB}.
  \item{\code{info_type}} The type of information. Accepts \code{FISHER}.
  \item{\code{initial_theta}} Initial theta value(s) for the first item selection.
  \item{\code{fixed_theta}} Fixed theta value(s) to optimize for all items to select.
}}

\item{content_balancing}{A list containing content balancing options.
\itemize{
  \item{\code{method}} The type of balancing method. Accepts one of \code{NONE, STA}.
}}

\item{MIP}{A list containing solver options.
\itemize{
  \item{\code{solver}} The type of solver. Accepts one of \code{SYMPHONY, GUROBI, GLPK, LPSOLVE}.
  \item{\code{verbosity}} Verbosity level.
  \item{\code{time_limit}} Time limit to be passed onto solver. Used in solvers \code{SYMPHONY, GUROBI, GLPK}.
  \item{\code{gap_limit}} Gap limit to be passed onto solver. Used in solvers \code{SYMPHONY, GUROBI}.
}}

\item{MCMC}{A list containing Markov-chain Monte Carlo configurations.
\itemize{
  \item{\code{burn_in}} Numeric. The number of chains from the start to discard.
  \item{\code{post_burn_in}}  Numeric. The number of chains to use after discarding the first \code{burn_in} chains.
  \item{\code{thin}} Numeric. Thinning interval.
  \item{\code{jumpfactor}} Numeric. Jump factor.
}}

\item{refresh_policy}{A list containing refresh policy for obtaining a new shadow test.
\itemize{
  \item{\code{method}} The type of policy. Accepts one of \code{ALWAYS, POSITION, INTERVAL, THRESHOLD, INTERVAL-THRESHOLD, STIMULUS, SET, PASSAGE}.
  \item{\code{interval}} Integer. Set to 1 to refresh at each position, 2 to refresh at every two positions, and so on.
  \item{\code{threshold}} Numeric. The shadow test is refreshed when the absolute change in theta estimate is greater than this value.
  \item{\code{position}} Numeric. Position(s) at which refresh to occur.
}}

\item{exposure_control}{A list containing exposure control settings.
\itemize{
  \item{\code{method}} Accepts one of \code{"NONE", "ELIGIBILITY", "BIGM", "BIGM-BAYESIAN"}.
  \item{\code{M}} Big M constant.
  \item{\code{max_exposure_rate}} Maximum target exposure rate.
  \item{\code{acceleration_factor}} Acceleration factor.
  \item{\code{n_segment}} Number of theta segments.
  \item{\code{first_segment}} Theta segment assumed at the begining of test.
  \item{\code{segment_cut}} A numeric vector of segment cuts.
  \item{\code{initial_eligibility_stats}} A list of eligibility statistics from a previous run.
  \item{\code{fading_factor}} Fading factor.
  \item{\code{diagnostic_stats}} \code{TRUE} to generate diagnostic statistics.
}}

\item{stopping_criterion}{A list containing stopping criterion.
\itemize{
  \item{\code{method}} Accepts one of \code{"FIXED"}.
  \item{\code{test_length}} Test length.
  \item{\code{min_ni}} Maximum number of items to administer.
  \item{\code{max_ni}} Minumum number of items to administer.
  \item{\code{se_threshold}} Standard error threshold for stopping.
}}

\item{interim_theta}{A list containing interim theta estimation options.
\itemize{
  \item{\code{method}} The type of estimation. Accepts one of \code{EAP, EB, FB}.
  \item{\code{shrinkage_correction}} Set \code{TRUE} to correct for shrinkage in EAP
  \item{\code{prior_dist}} The type of prior distribution. Accepts one of \code{NORMAL, UNIF}.
  \item{\code{prior_par}} Distributional parameters for the prior.
  \item{\code{bound_ML}} Theta bound for MLE.
  \item{\code{truncate_ML}} Set \code{TRUE} to truncate MLE within \code{bound_ML}
  \item{\code{max_iter}} Maximum number of Newton-Raphson iterations.
  \item{\code{crit}} Convergence criterion.
  \item{\code{max_change}} Maximum change in ML estimates between iterations.
  \item{\code{do_fisher}} Set \code{TRUE} to use Fisher's method of scoring.
}}

\item{final_theta}{A list containing final theta estimation options.
\itemize{
  \item{\code{method}} The type of estimation. Accepts one of \code{EAP, EB, FB}.
  \item{\code{shrinkage_correction}} Set \code{TRUE} to correct for shrinkage in EAP.
  \item{\code{prior_dist}} The type of prior distribution. Accepts one of \code{NORMAL, UNIF}.
  \item{\code{prior_par}} Distributional parameters for the prior.
  \item{\code{bound_ML}} Theta bound for MLE.
  \item{\code{truncate_ML}} Set \code{TRUE} to truncate MLE within \code{bound_ML}
  \item{\code{max_iter}} Maximum number of Newton-Raphson iterations.
  \item{\code{crit}} Convergence criterion.
  \item{\code{max_change}} Maximum change in ML estimates between iterations.
  \item{\code{do_fisher}} Set \code{TRUE} to use Fisher's method of scoring.
}}

\item{theta_grid}{A numeric vector. Theta values to represent the continuum.}

\item{audit_trail}{Set \code{TRUE} to generate audit trails.}
}
\description{
Create a \code{\linkS4class{config_Shadow}} object for Shadow Test Assembly (STA).
}
\examples{
cfg1 <- createShadowTestConfig(refresh_policy = list(
  method = "STIMULUS"
))
cfg2 <- createShadowTestConfig(refresh_policy = list(
  method = "POSITION",
  position = c(1, 5, 9)
))
}
