% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{covD2nd}
\alias{covD2nd}
\title{Returns the theoretical covariance of empirical correlations.}
\usage{
covD2nd(r)
}
\arguments{
\item{r}{a correlation matrix}
}
\value{
Returns the theoretical covariance of 2nd order statistics, 
        \eqn{\sqrt{n}*mean(Y)/sd(Y)} with \eqn{Y=(X_i-mean(X_i))(X_j-mean(X_j))}.
}
\description{
Returns the theoretical covariance of empirical correlations.
}
\examples{
p <- 10
corr_theo <- diag(1,p)
corr_theo[2:p,] <- 0.3
corr_theo[,2:p] <- 0.3
covD2nd(corr_theo)
}
\seealso{
covDcor
}
