% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogLik.R
\name{SurvLogLik}
\alias{SurvLogLik}
\title{Log Likelihood}
\usage{
SurvLogLik(
  data,
  dist,
  theta,
  log_scale = FALSE,
  status_name = "status",
  time_name = "time"
)
}
\arguments{
\item{data}{Data.frame}

\item{dist}{Distribution, from among: "exp","gamma","gen-gamma","log-normal","weibull".}

\item{theta}{Parameters, which will vary according to the distribution.}

\item{log_scale}{Are strictly positive parameters on log-scale?}

\item{status_name}{Status indicator, coded as 1 if an event was observed, 0 if censored.}

\item{time_name}{Name of column containing the time to event.}
}
\value{
Scalar value of the log likelihood.
}
\description{
Evaluates the log-likelihood for a parametric survival distribution.
}
\details{
The parameter vector theta should contain the following elements, in order,
depending on the distribution:
\describe{
 \item{Exponential}{Rate \eqn{\lambda}.}
 \item{Gamma}{Shape \eqn{\alpha}, rate \eqn{\lambda}.}
 \item{Generalized Gamma}{Shape 1 \eqn{\alpha}, shape 2 \eqn{\beta}, rate \eqn{\lambda}.}
 \item{Log-Normal}{Location \eqn{\mu}, scale \eqn{\sigma}.}
 \item{Weibull}{Shape \eqn{\alpha}, rate \eqn{\lambda}.}
}
}
\examples{
# Generate gamma event time data with 10\% censoring.
data <- GenData(n = 1e3, dist = "gamma", theta = c(2, 2), p = 0.1)

# Evaluate log likelihood.
ll <- SurvLogLik(data, dist = "gamma", theta = c(2, 2))

# Generate Weibull event time data with 20\% censoring.
data <- GenData(n = 1e3, dist = "weibull", theta = c(2, 2), p = 0.2)

# Evaluate log likelihood.
ll <- SurvLogLik(data, dist = "weibull", theta = c(2, 2))
}
