% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataGen.R
\name{rLogLogistic}
\alias{rLogLogistic}
\title{Simulation from the Log-Logistic Distribution}
\usage{
rLogLogistic(n, a = 4, l = 1, p = 0)
}
\arguments{
\item{n}{Sample size.}

\item{a}{Shape.}

\item{l}{Rate.}

\item{p}{Expected censoring proportion.}
}
\value{
A data.frame including the observation times and status indicators.
}
\description{
Generates log-logistic event times with shape parameter \eqn{\alpha} and rate
parameter \eqn{\lambda}. See \code{\link{fit.LogLogistic}} for the
parameterization. If a censoring proportion \eqn{p} is provided, the event
times are subject to non-informative random right censoring.
}
\examples{
# Log-logistic event times with shape 4 and rate 1
# Expected censoring proportion of 20\%
D = rLogLogistic(n=1e3,a=4,l=1,p=0.2);
}
