% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/times.R
\name{times}
\alias{times}
\alias{getTargomoTimes}
\alias{drawTargomoTimes}
\alias{addTargomoTimes}
\title{Add Targomo Times to a Leaflet Map}
\usage{
getTargomoTimes(source_data = NULL, source_lat = NULL,
  source_lng = NULL, target_data = NULL, target_lat = NULL,
  target_lng = NULL, source_id = NULL, target_id = NULL,
  options = targomoOptions(), api_key = Sys.getenv("TARGOMO_API_KEY"),
  region = Sys.getenv("TARGOMO_REGION"), config = list(),
  verbose = FALSE, progress = FALSE, timeout = NULL)

drawTargomoTimes(map, times, drawOptions = timeDrawOptions(),
  group = NULL, ...)

addTargomoTimes(map, source_data = NULL, source_lat = NULL,
  source_lng = NULL, target_data = NULL, target_lat = NULL,
  target_lng = NULL, source_id = NULL, target_id = NULL,
  options = targomoOptions(), drawOptions = timeDrawOptions(),
  group = NULL, ..., api_key = Sys.getenv("TARGOMO_API_KEY"),
  region = Sys.getenv("TARGOMO_REGION"), config = list(),
  verbose = FALSE, progress = FALSE, timeout = NULL)
}
\arguments{
\item{source_data, target_data}{The source and target points for your travel times -
supported types are data.frame matrix and objects from the sf and sp packages.}

\item{source_lat, source_lng}{One-sided formulas identifying the latitude
and longitude columns in your source data, or numeric vectors of equal length.}

\item{target_lat, target_lng}{As for \code{source_lat,source_lng} but for target data.}

\item{source_id, target_id}{Formulas or vectors of IDs to give to your source and target points.
These will be used to match back to the input data if applicable.}

\item{options}{A list of \code{\link{targomoOptions}} to send to the API.}

\item{api_key}{Your Targomo API key - defaults to the \code{TARGOMO_API_KEY}
ennvironment variable.}

\item{region}{Your Targomo region - defaults to the \code{TARGOMO_REGION}
environment variable.}

\item{config}{Config options to pass to \code{httr::POST} e.g. proxy settings}

\item{verbose}{Whether to print out information about the API call.}

\item{progress}{Whether to show a progress bar of the API call.}

\item{timeout}{Timeout in seconds (leave NULL for no timeout/curl default).}

\item{map}{A leaflet map}

\item{times}{A times dataset returned by \code{getTargomoTimes}}

\item{drawOptions}{A list of \code{\link{timeDrawOptions}} to determine how to show
the resulting times on the map.}

\item{group}{The leaflet map group to add the times to. One group is used for all
map elements being drawn per call to the API.}

\item{...}{Further arguments to pass to \code{\link[leaflet]{addCircleMarkers}}}
}
\value{
For `get*`, an object of class "sf" containing the times. For `draw*` and `add*`,
  the leaflet map returned with the times drawn on as circle markers.
}
\description{
This function takes source and target data, together with options for the API and
drawing options, and returns the map with the requested travel time data.
}
\examples{
\donttest{
# load leaflet package
library(leaflet)
l <- leaflet()

# create a source point (Big Ben) and some random targets
s <- data.frame(lat = 51.5007, lng = -0.1246, id = "BigBen")
t <- data.frame(lat = runif(min = 51.495, max = 51.5055, n = 100),
                lng = runif(min = -0.175, max = -0.075, n = 100))

# get the times
times <- getTargomoTimes(source_data = s, target_data = t,
                         options = targomoOptions(travelType = "car"))

# draw them on the map
l \%>\% drawTargomoTimes(times = times)

}

}
