% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PLOT.TTS.R
\name{PLOT.TTS}
\alias{PLOT.TTS}
\title{Time-Temperature Superposition (TTS) plots}
\usage{
PLOT.TTS(x)
}
\arguments{
\item{x}{TTS object.}
}
\value{
The following values are returned: \item{PLOT.data()}{Generic
function to plot the experimental data. By default log10.module versus
log10.frequency.} \item{PLOT.aT()}{Generic plot of the horizontal shifts
corresponding to each curve (modulus versus frequency) obtained on
temperature.} \item{PLOT.bT()}{Generic plot of the vertical shifts
corresponding to each curve (modulus versus frequency) obtained on
temperature.} \item{PLOT.TTS.data()}{Generic plot of the experimental data
horizontally and vertically shifted with respect to a the curve
corresponding to the reference temperature.} \item{PLOT.TTS.gam()}{Generic
plot of the Master Curve B-splines estimation with bootstrap confidence
intervals at 95 per cent.} \item{PLOT.res()}{Generic plot of the residuals
of Master Curve B-splines fitting.}
}
\description{
Plots of TTS results: experimental data, horizontal and vertical shifts,
TTS data, TTS Master Curve fitting with B-Splines and bootstrap confidence
intervals are deployed.
}
\details{
TTS plots are performed from the outputs of TTS function: data, aT, bT,
TTS.data, TTS.gam y residuals.
}
\examples{
## TTS object applied to PC dataset.
data(PC)
Derive <- TTS(PC)
x <- Derive
## Generic plots for TTS analysis
PLOT <- PLOT.TTS(x)
names(PLOT)
##[1] "PLOT.data"  "PLOT.aT"   "PLOT.bT"   "PLOT.TTS.data"
##[5] "PLOT.TTS.gam"  "PLOT.res"
## Generic plots of: data, aT, bT, TTS.data, TTS.gam and res
PLOT$PLOT.data(main="PLOT: Data",xlab="log10.Frequency (rad/s)",
               ylab="log10.E'(Pa)")
PLOT$PLOT.aT(main="PLOT: horizontal translation factors",
               xlab="Temperature", ylab="aT")
PLOT$PLOT.bT(main="PLOT: vertical translation factors",
               xlab="Temperature",ylab="bT")
PLOT$PLOT.TTS.data(xlab="log10.Frequency (rad/s)",
               ylab="log10.E'(Pa)")
PLOT$PLOT.TTS.gam( xlab="log10.Frequency (rad/s)",
                ylab = "log10.E'(Pa)",
     main = "Fitted gam, Bootstrap confidence intervals",
     sub = "Reference temperature = 150 degrees celsius")
PLOT$PLOT.res(main="TTS: gam residual", xlab="Fitted",
                 ylab="Standardized residuals")
}
\author{
Antonio Meneses \email{antoniomenesesfreire@hotmail.com}, Salvador
Naya \email{salva@udc.es} and Javier Tarrio-Saavedra
\email{jtarrio@udc.es}
}
\references{
Naya, S., Meneses A., Tarrio-Saavedra, J., Artiaga R.,
Lopez-Beceiro, J. and Gracia-Fernandez C. (2013) New method for estimating
shift factors in time-temperatura superposition models. Journal of Thermal
Analysis and Calorimetry. ISSN 1388-6150. DOI 10.1007/s10973-013-3193-1.\cr

Williams, M. L. (1964) Structural analysis of Viscoelastic materials. AIAA
Journal, 785-808.\cr

Artiaga R., Garcia A. Fundamentals of DMA. In: 'Thermal analysis.
Fundamentals and applications to material characterization' (ed.: Artiaga
R.) Publicaciones de la Universidade da Coruna, A Coruna, Spain, 183-206
(2005).\cr
}
\keyword{TTS.PLOT()}

