% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_functions.R
\name{ts_backtesting}
\alias{ts_backtesting}
\title{Evaluation Function for Forecasting Models}
\usage{
ts_backtesting(ts.obj, models = "abehntw", periods = 6,
  error = "MAPE", window_size = 3, h = 3, plot = TRUE,
  a.arg = NULL, b.arg = NULL, e.arg = NULL, h.arg = NULL,
  n.arg = NULL, t.arg = NULL, w.arg = NULL, xreg.h = NULL,
  parallel = FALSE)
}
\arguments{
\item{ts.obj}{A univariate time series object of a class "ts"}

\item{models}{String, define the type of models to use in the training function:

 'a' - auto.arima (forecast package)
 
 'b' - Bayesian Structural Time Series (bsts package)
 
 'e' - ets (forecast package) 
 
 'h' - hybrid timse series model (forecastHybrid package) 
 
 'n' - Neural Network Time Series (forecast package)
 
 't' - tbats (forecast package)
 
 'w' - Holt Winters (stats package)}

\item{periods}{The number of periods to evaluate the models (with a minimum of 2)}

\item{error}{The type of error to evaluate by - "MAPE"  (default) or "RMSE"}

\item{window_size}{An integer, the size of the backtesting window}

\item{h}{Integer, the horizon of the selected forecasting model}

\item{plot}{Logical, if TRUE desplay a plot with the backtesting progress}

\item{a.arg}{A list, an optional arguments to pass to the \code{\link[forecast]{auto.arima}} function}

\item{b.arg}{A list, an optional arguments to pass to the \code{\link[bsts]{bsts}} function}

\item{e.arg}{A list, an optional argument to pass to the \code{\link[forecast]{ets}} function}

\item{h.arg}{A list, an optional argument to pass to the \code{\link[forecastHybrid]{hybridModel}} function}

\item{n.arg}{A list, an optional argument to pass to the \code{\link[forecast]{nnetar}} function}

\item{t.arg}{A list, an optional arguments to pass to the \code{\link[forecast]{tbats}} function}

\item{w.arg}{A list, an optional arguments to pass to the \code{\link[stats]{HoltWinters}} function}

\item{xreg.h}{A data.frame or matrix, optional argument, 
set the futuer values external regressors in case using the 
'xreg' argument in one of the models (auto.arima, nnetar, hybrid)}

\item{parallel}{Logical, if TRUE use parallel option when applicable (auto.arima, hybridModel)}
}
\description{
Performance evaluation function for forecasting models, by training and testing the performance
of each model over a sequence of periods to identify the performance of a model over time  
(both accuracy and stability)
}
\examples{
\dontrun{
data(USgas)
USgas_backtesting <- ts_backtesting(USgas, 
                                    periods = 6, 
                                    window_size = 24, 
                                    h = 60, 
                                    error = "RMSE")

# Selecting a specific models (auto.arima, ets and nnetar)
USgas_backtesting <- ts_backtesting(USgas, 
                                    models = "aen", 
                                    periods = 6, 
                                    window_size = 24, 
                                    h = 60)
 
# Retrieve the models leaderboard
USgas_backtesting$leaderboard


# Retrieve the best forecast results
USgas_backtesting$leadForecast$mean

# Retrieve the final forecast of the ets model
USgas_backtesting$Forecast_Final$ets$mean

# Retrieve the ets forecast during the first period of testing
USgas_backtesting$period_1$ets$forecast$mean

# Get the final plot of the models performance and the selected forecasting model
USgas_backtesting$summary_plot
}
}
