% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{trending}
\alias{trending}
\title{Creates bit-level (trending) representation from a vector}
\usage{
trending(x)
}
\arguments{
\item{x}{the numeric vector (time series)}
}
\value{
the integer vector of zeros and ones
}
\description{
The \code{trending} Computes bit-level (trending) representation from a vector.
}
\details{
Trending transforms time series to bit-level representation.

It is defined as follows:
\deqn{repr_t   =   {1   if   x_t  -  x_{t+1}  <  0 ,  0   otherwise,}}{repr_t   =   {1   if   x_t  -  x_{t+1}  <  0 ,  0   otherwise,}}
where \eqn{x_t} is a value of a time series.
}
\examples{
trending(rnorm(50))

}
\seealso{
\code{\link[TSrepr]{clipping}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
