% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repr_matrix.R
\name{repr_matrix}
\alias{repr_matrix}
\title{Computation of matrix of representations from matrix of time series}
\usage{
repr_matrix(
  x,
  func = NULL,
  args = NULL,
  normalise = FALSE,
  func_norm = norm_z,
  windowing = FALSE,
  win_size = NULL
)
}
\arguments{
\item{x}{the matrix, data.frame or data.table of time series, where time series are in rows of the table}

\item{func}{the function that computes representation}

\item{args}{the list of additional (or required) parameters of func (function that computes representation)}

\item{normalise}{normalise (scale) time series before representations computation? (default is FALSE)}

\item{func_norm}{the normalisation function (default is \code{norm_z})}

\item{windowing}{perform windowing? (default is FALSE)}

\item{win_size}{the size of the window}
}
\value{
the numeric matrix of representations of time series
}
\description{
The \code{repr_matrix} computes matrix of representations from matrix of time series
}
\details{
This function computes representation to an every row of a matrix of time series and returns matrix of time series representations.
It can be combined with windowing (see \code{\link{repr_windowing}}) and normalisation of time series.
}
\examples{
# Create random matrix of time series
mat_ts <- matrix(rnorm(100), ncol = 10)
repr_matrix(mat_ts, func = repr_paa,
 args = list(q = 5, func = meanC))

# return normalised representations, and normalise time series by min-max normalisation
repr_matrix(mat_ts, func = repr_paa,
 args = list(q = 2, func = meanC), normalise = TRUE, func_norm = norm_min_max)

# with windowing
repr_matrix(mat_ts, func = repr_feaclip, windowing = TRUE, win_size = 5)

}
\seealso{
\code{\link[TSrepr]{repr_windowing}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
