% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.r
\name{train}
\alias{train}
\alias{train.MLM}
\alias{train.linear}
\title{Training a time series model}
\usage{
train(obj, ...)

\method{train}{MLM}(obj, data, ...)

\method{train}{linear}(obj, data, ...)
}
\arguments{
\item{obj}{An object of class \code{\link{modeling}} defining a particular model.}

\item{...}{Other parameters passed to \code{train_func} of \code{obj}.

For \code{train.MLM}, \code{sw} of \code{obj} may be used to transform the time series 
in \code{data} into sliding windows used during training. Also, 
\code{proc} of \code{obj} may be used to preprocess the time series before training.}

\item{data}{A list of time series to be modelled.}
}
\value{
A list containing \code{obj} and the trained models.
}
\description{
\code{train} is a generic function for training a time series model
based on a particular training function defined in a \code{\link{modeling}} object.
The function invokes particular \emph{methods} which
depend on the class of the first argument.
}
\examples{
data(CATS,CATS.cont)

a <- ARIMA()
model <- train(a,list(CATS[,1]))

n <- NNET(size=5, sw=SW(window_len = 5+1), proc=list(MM=MinMax()))
model <- train(n,list(CATS[,1]))

}
\seealso{
Other train: 
\code{\link{train.tspred}()}
}
\author{
Rebecca Pontes Salles
}
\concept{train}
\keyword{model}
\keyword{training}
