% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.r
\name{preprocess}
\alias{preprocess}
\alias{postprocess}
\alias{preprocess.processing}
\alias{postprocess.processing}
\title{Preprocessing/Postprocessing time series data}
\usage{
preprocess(obj, ...)

\method{preprocess}{processing}(obj, data, ..., map = TRUE)

postprocess(obj, ...)

\method{postprocess}{processing}(obj, data, ..., map = TRUE)
}
\arguments{
\item{obj}{An object of class \code{\link{processing}} defining a particular transformation method.}

\item{...}{Other parameters passed to \code{prep_func}/\code{postp_func} of \code{obj}.}

\item{data}{A list of time series to be transformed.}

\item{map}{Should the transformation be performed in each individual time series?
If \code{FALSE} the function processes the provided set of time series as a whole.}
}
\value{
A list containing \code{obj} and the transformed time series.
}
\description{
\code{preprocess} and \code{postprocess} are generic functions for
preprocessing and postprocessing time series data, respectively, based on 
a particular transformation method defined in a \code{\link{processing}} object.
Generally, postprocessing reverses the transformation performed during preprocessing.
}
\examples{
data(NN5.A)
t <- LT(base = exp(1))
prep_ts <- preprocess(t,list(NN5.A[,10]))$results[[1]]$res
postp_ts <- postprocess(t,list(prep_ts))$results[[1]]$res

}
\author{
Rebecca Pontes Salles
}
\concept{processing}
\keyword{postprocessing}
\keyword{preprocessing}
\keyword{processing}
\keyword{transformation}
