% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minmax.r
\name{minmax}
\alias{minmax}
\alias{minmax.rev}
\title{Minmax Data Normalization}
\usage{
minmax(data, max = NULL, min = NULL, byRow = FALSE)

minmax.rev(data, max, min)
}
\arguments{
\item{data}{A numeric vector, a univariate time series containing the values to
be normalized, or a matrix with sliding windows as returned by \code{\link{sw}}.}

\item{max}{Integer indicating the maximal value in \code{data}, 
or a vector with the maximal values of each row (sliding window) in \code{data}.
If \code{NULL} it is automatically computed.}

\item{min}{Integer indicating the minimum value in \code{data}, 
or a vector with the minimum values of each row (sliding window) in \code{data}.
If \code{NULL} it is automatically computed.}

\item{byRow}{If \code{TRUE}, the normalization is performed by rows (sliding windows).
Default set to \code{FALSE}.}
}
\value{
\code{data} normalized between 0 and 1. If \code{byRow} is \code{TRUE}, 
		the function returns \code{data} normalized by rows (sliding windows).
	\code{max} and \code{min} are returned as attributes.
}
\description{
The \code{minmax()} function normalizes data of the provided time series 
to bring values into the range [0,1]. \code{minmax.rev()} reverses the
normalization.
}
\details{
Ranging is done by using: \deqn{X' = \frac{(x - x_{min})}{(x_{max} - x_{min})}}.
}
\examples{

data(CATS)
d <- minmax(CATS[,1])
x <- minmax.rev(d, max = attributes(d)$max, min = attributes(d)$min)
all(round(x,4)==round(CATS[,1],4))

d <- minmax(sw(CATS[,1],5), byRow = TRUE)
x <- minmax.rev(d, max = attributes(d)$max, min = attributes(d)$min)
all(round(x,4)==round(sw(CATS[,1],5),4))

}
\references{
R.J. Hyndman and G. Athanasopoulos, 2013, Forecasting:
principles and practice. OTexts.

E. Ogasawara, L. C. Martinez, D. De Oliveira, G. Zimbrao, G. L. Pappa, and M. Mattoso, 2010,
Adaptive Normalization: A novel data normalization approach for non-stationary time series, 
Proceedings of the International Joint Conference on Neural Networks.
}
\seealso{
Other normalization methods: 
\code{\link{an}()}
}
\author{
Rebecca Pontes Salles
}
\concept{normalization methods}
\keyword{normalization}
\keyword{series}
\keyword{time}
