% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSLSTM.R
\name{ts.prepare.data}
\alias{ts.prepare.data}
\title{Prepare data for Long Short Term Memory (LSTM) Model for Time Series Forecasting}
\usage{
ts.prepare.data(ts, xreg = NULL, tsLag, xregLag = 0)
}
\arguments{
\item{ts}{Time series data}

\item{xreg}{Exogenous variables}

\item{tsLag}{Lag of time series data}

\item{xregLag}{Lag of exogenous variables}
}
\value{
dataset with all lags created from exogenous and time series data.
}
\description{
The LSTM (Long Short-Term Memory) model is a Recurrent Neural Network (RNN) based architecture that is widely used for time series forecasting. Min-Max transformation has been used for data preparation. Here, we have used one LSTM layer as a simple LSTM model and a Dense layer is used as the output layer. Then, compile the model using the loss function, optimizer and metrics. This package is based on 'keras' and TensorFlow modules.
}
\examples{
  y <- rnorm(100,mean=100,sd=50)
  x1 <- rnorm(100,mean=50,sd=50)
  x2 <- rnorm(100, mean=50, sd=25)
  x <- cbind(x1,x2)
  ts.prepare.data(y, x, 2, 4)

}
