% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trex.R
\name{trex}
\alias{trex}
\title{Run the T-Rex selector}
\usage{
trex(
  X,
  y,
  tFDR = 0.2,
  K = 20,
  max_num_dummies = 10,
  max_T_stop = TRUE,
  method = "trex",
  type = "lar",
  corr_max = 0.5,
  lambda_2_lars = NULL,
  parallel_process = FALSE,
  parallel_max_cores = min(K, max(1, parallel::detectCores(logical = FALSE))),
  seed = NULL,
  eps = .Machine$double.eps,
  verbose = TRUE
)
}
\arguments{
\item{X}{Real valued predictor matrix.}

\item{y}{Response vector.}

\item{tFDR}{Target FDR level (between 0 and 1, i.e., 0\% and 100\%).}

\item{K}{Number of random experiments.}

\item{max_num_dummies}{Integer factor determining the maximum number of dummies as a multiple of the number of original variables p
(i.e., num_dummies = max_num_dummies * p).}

\item{max_T_stop}{If TRUE the maximum number of dummies that can be included before stopping is set to ceiling(n / 2),
where n is the number of data points/observations.}

\item{method}{'trex' for the T-Rex selector and 'trex+GVS' for the T-Rex+GVS selector.}

\item{type}{'lar' for 'LARS' and 'lasso' for Lasso.}

\item{corr_max}{Maximum allowed correlation between any two predictors from different clusters.}

\item{lambda_2_lars}{lambda_2-value for LARS-based Elastic Net.}

\item{parallel_process}{Logical. If TRUE random experiments are executed in parallel.}

\item{parallel_max_cores}{Maximum number of cores to be used for parallel processing
(default: minimum{Number of random experiments K, number of physical cores}).}

\item{seed}{Seed for random number generator (ignored if parallel_process = FALSE).}

\item{eps}{Numerical zero.}

\item{verbose}{Logical. If TRUE progress in computations is shown.}
}
\value{
A list containing the estimated support vector and additional information, including the number of used dummies and the number of included dummies before stopping.
}
\description{
Run the T-Rex selector The T-Rex selector performs fast variable selection in high-dimensional settings while
controlling the false discovery rate (FDR) at a user-defined target level.
}
\examples{
data("Gauss_data")
X <- Gauss_data$X
y <- c(Gauss_data$y)
set.seed(1234)
res <- trex(X = X, y = y)
selected_var <- res$selected_var
selected_var
}
