% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEG.R
\docType{data}
\name{EEG}
\alias{EEG}
\title{Electroencephalography (EEG) dataset for alcoholism study.}
\format{
A list consisting of two components:
\describe{
 \item{x}{A binary vector with length of 61.}
 \item{y}{A \eqn{64 \times 64 \times 61} tensor, consisting of 61 \emph{channels} by \emph{time} EEG images.}
}
}
\usage{
data("EEG")
}
\description{
EEG images data of subjects in alcoholic and control groups.
}
\details{
The original EEG data contains 77 alcoholic individuals and 45 controls. To reduce the size, we randomly select 61 samples and obtain 39 alcoholic individuals and 22 controls. Each individual was measured with 64 electrodes placed on the scalp sampled at 256 Hz for 1 sec, resulting an EEG image of 64 channels by 256 time points. More information about data collection and some analysis can be found in Zhang et al. (1995) and Li, Kim, and Altman (2010). To facilitate the analysis, the data is downsized along the time domain by averaging every four consecutive time points, yielding a 64 × 64 matrix response.
}
\examples{
data("EEG")
x <- EEG$x
y <- EEG$y
## Estimate the envelope dimension, the output should be c(1,1).
\dontrun{
u <- TRRdim(x, y)$u}
u <- c(1,1)

## Fit the dataset with TRR.fit and draw the coefficient plot and p-value plot
fit_1D <- TRR.fit(x, y, u, method = "1D")
plot(fit_1D, xlab = "Time", ylab = "Channels")

## Uncomment display the plots from different methods.
# fit_ols <- TRR.fit(x, y, method = "standard")
# fit_pls <- TRR.fit(x, y, u, method = "PLS")
# plot(fit_ols, xlab = "Time", ylab = "Channels")
# plot(fit_pls, xlab = "Time", ylab = "Channels")

}
\references{
URL: \url{https://archive.ics.uci.edu/ml/datasets/EEG+Database}.

Li, L. and Zhang, X., 2017. Parsimonious tensor response regression. Journal of the American Statistical Association, 112(519), pp.1131-1146.

Zhang, X.L., Begleiter, H., Porjesz, B., Wang, W. and Litke, A., 1995. Event related potentials during object recognition tasks. Brain research bulletin, 38(6), pp.531-538.

Li, B., Kim, M.K. and Altman, N., 2010. On dimension folding of matrix-or array-valued statistical objects. The Annals of Statistics, 38(2), pp.1094-1121.
}
\keyword{datasets}
