% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.Tenv.R
\name{summary.Tenv}
\alias{summary.Tenv}
\alias{print.summary.Tenv}
\title{Summarize method for Tenv object.
Summary method for object returned from \code{\link{TRR}} and \code{\link{TPR}} functions.}
\usage{
\method{summary}{Tenv}(object, ...)

\method{print}{summary.Tenv}(x, ...)
}
\arguments{
\item{object}{An object of class "Tenv", as from \code{\link{TPR}} or \code{\link{TRR}}.}

\item{...}{Arguments to be passed to or from other methods.}

\item{x}{An object of class "summary.Tenv", usually, a result of a call to summary.Tenv.}
}
\value{
\code{object} With additional components
\describe{
 \item{n}{Sample size}
 \item{xdim}{Dimensions of predictor}
 \item{ydim}{Dimensions of response}
 \item{mse}{Mean squared error based on \code{residuals(object)}}
 \item{p_val}{Only for object returned from \code{\link{TRR}}, p-value for coefficients}
 \item{se}{Only for object returned from \code{\link{TRR}}, standard error for coefficients}
}
}
\description{
The p-value and standard error for coefficients are only calculated for the object returned from \code{\link{TRR}}.
}
\details{
print.summary.Tenv print.summary.lm gives a more readable format of sample size, dimensions of datasets, mse,
and additionally gives \code{p-val} and \code{se} if \code{object} is returned from \code{\link{TRR}}.
}
\examples{
data("bat")
Xn <- bat$Xn
Yn <- bat$Yn
fit <- TRR(Xn, Yn, method="standard")
##print summary
summary(fit)
}
\seealso{
\code{\link{Tenv_Pval}}
}
