% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_cross.R
\name{table_cross}
\alias{table_cross}
\title{Table cross used to cross search and merge results in two tables.}
\usage{
table_cross(
  data1,
  data2,
  inter_var = "Genes",
  left_index = TRUE,
  right_index = TRUE
)
}
\arguments{
\item{data1}{Dataframe: Shared DEGs of all paired comparisons in all samples expression dataframe of RNA-Seq. (1st-col: Genes, 2nd-col~: Samples).}

\item{data2}{Dataframe: GO and KEGG annotation of background genes (1st-col: Genes, 2nd-col: biological_process, 3rd-col: cellular_component, 4th-col: molecular_function, 5th-col: kegg_pathway).}

\item{inter_var}{Character: Intersecting variable (column name). Default: "geneID" in example data.}

\item{left_index}{Logical: left table as index. Default: TRUE, options: TRUE, FALSE.}

\item{right_index}{Logical: right table as index. Default: FALSE, options: TRUE, FALSE.}
}
\value{
Table: include multiple columns.
}
\description{
Table cross used to cross search and merge results in two tables.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(gene_expression2)
head(gene_expression2)

data(gene_go_kegg)
head(gene_go_kegg)

# 3. Default parameters
res <- table_cross(gene_expression2, gene_go_kegg, inter_var = "Genes")
head(res)

# 4. Set left_index = TRUE, right_index = FALSE
res <- table_cross(gene_expression2, gene_go_kegg,
inter_var = "Genes", left_index = TRUE, right_index = FALSE)
head(res)

# 5. Set left_index = FALSE, right_index = TRUE
res <- table_cross(gene_expression2, gene_go_kegg,
inter_var = "Genes", left_index = FALSE, right_index = TRUE)
head(res)

}
\author{
benben-miao
}
