% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_heatmap.R
\name{corr_heatmap}
\alias{corr_heatmap}
\title{Correlation Heatmap for samples/groups based on Pearson algorithm.}
\usage{
corr_heatmap(
  data,
  corr_method = "pearson",
  cell_shape = "square",
  fill_type = "full",
  lable_size = 3,
  axis_angle = 45,
  axis_size = 12,
  lable_digits = 3,
  color_low = "blue",
  color_mid = "white",
  color_high = "red",
  outline_color = "white",
  ggTheme = "theme_light"
)
}
\arguments{
\item{data}{Dataframe: All genes in all samples expression dataframe of RNA-Seq (1st-col: Genes, 2nd-col~: Samples).}

\item{corr_method}{Character: correlation method. Default: "pearson", options: "pearson", "spearman", "kendall".}

\item{cell_shape}{Character: heatmap cell shape. Default: "square", options: "circle", "square".}

\item{fill_type}{Character: heatmap fill type. Default: "full", options: "upper", "low", "full".}

\item{lable_size}{Numeric: heatmap label size. Default: 3, min: 0.}

\item{axis_angle}{Numeric: axis rotate angle. Default: 45, min: 0, max: 360.}

\item{axis_size}{Numberic: axis font size. Default: 12, min: 0.}

\item{lable_digits}{Numeric: heatmap label digits. Default: 3, min: 0, max: 3.}

\item{color_low}{Character: low value color name or hex value. Default: "blue".}

\item{color_mid}{Character: middle value color name or hex value. Default: "white".}

\item{color_high}{Character: high value color name or hex value. Default: "red".}

\item{outline_color}{Character: outline color name or hex value. Default: "white".}

\item{ggTheme}{Character: ggplot2 theme. Default: "theme_light", options: "theme_default", "theme_bw", "theme_gray", "theme_light", "theme_linedraw", "theme_dark", "theme_minimal", "theme_classic", "theme_void".}
}
\value{
Plot: heatmap plot filled with Pearson correlation values and P values.
}
\description{
Correlation Heatmap for samples/groups based on Pearson algorithm.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset gene_exp
data(gene_expression)
head(gene_expression)

# 3. Default parameters
corr_heatmap(gene_expression)

# 4. Set color_low = "#008800"
corr_heatmap(gene_expression, color_low = "#008800")

# 5. Set cell_shape = "circle"
corr_heatmap(gene_expression, cell_shape = "circle")

}
\author{
benben-miao
}
