% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circos_heatmap.R
\name{circos_heatmap}
\alias{circos_heatmap}
\title{Circos heatmap plot for visualizing gene expressing in multiple samples.}
\usage{
circos_heatmap(
  data,
  low_color = "#0000ff",
  mid_color = "#ffffff",
  high_color = "#ff0000",
  gap_size = 25,
  cluster_run = TRUE,
  cluster_method = "complete",
  distance_method = "euclidean",
  dend_show = "inside",
  dend_height = 0.2,
  track_height = 0.3,
  rowname_show = "outside",
  rowname_size = 0.8
)
}
\arguments{
\item{data}{Dataframe: Shared degs of all paired comparisons in all samples expression dataframe of RNA-Seq. (1st-col: Genes, 2nd-col~: Samples).}

\item{low_color}{Character: min value color (color name or hex value). Default: "#0000ff".}

\item{mid_color}{Character: middle value color (color name or hex value). Default: "#ffffff".}

\item{high_color}{Character: high value color (color name or hex value). Default: "#ff0000".}

\item{gap_size}{Numeric: heatmap gap size. Default: 25, min: 0.}

\item{cluster_run}{Logical: running cluster algorithm. Default: TRUE, options: TRUE, FALSE.}

\item{cluster_method}{Character: cluster methods. Default: "complete", options: "ward.D", "ward.D2", "single", "complete", "average", "mcquitty", "median", "centroid".}

\item{distance_method}{Character: distance methods. Default: "euclidean", options: "euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski".}

\item{dend_show}{Character: control dendgram display and position. Default: "inside", options: "none", "outside", "inside".}

\item{dend_height}{Numeric: dendgram height. Default: 0.20, min: 0.00, max: 0.50.}

\item{track_height}{Numeric: heatmap track height. Default: 0.30, min: 0.00, max: 0.50.}

\item{rowname_show}{Character: control rownames display and position. Hind first rowname by running rownames(data). Default: "outside", options: "none", "outside", "inside".}

\item{rowname_size}{Numeric: rowname font size. Default: 0.80, min: 0.10, max: 10.00.}
}
\value{
Plot: circos heatmap plot for visualizing gene expressing in multiple samples.
}
\description{
Circos heatmap plot for visualizing gene expressing in multiple samples.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(gene_expression2)
head(gene_expression2)

# 3. Default parameters
circos_heatmap(gene_expression2[1:50,])

}
\author{
benben-miao
}
