% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_bootstrapper.R
\name{gamma_bootstrapper}
\alias{gamma_bootstrapper}
\title{Function to bootstrap the Cumulative Distribution Functions (CDFs) of the TMTI statistics.}
\usage{
gamma_bootstrapper(
  m,
  n = Inf,
  B = 1000,
  log.p = TRUE,
  mc.cores = 1L,
  tau = NULL,
  K = NULL
)
}
\arguments{
\item{m}{Number of tests}

\item{n}{Number (or Inf) indicating what kind of minimum to consider.
Defaults to Inf, corresponding to the global minimum.}

\item{B}{Number of bootstrap replicates. Rule of thumb is to use at least
10 * m}

\item{log.p}{Logical indicating whether to calculate p-values on log-scale.
Defaults to TRUE}

\item{mc.cores}{Integer denoting the number of cores to use when using
parallelization, Defaults to 1, corresponding to single-threaded computations}

\item{tau}{Numerical (in (0,1)); threshold to use in tTMTI. If set to NULL,
then either TMTI (default) or rtTMTI is used.}

\item{K}{Integer; Number of smallest p-values to use in rtTMTI. If se to NULL,
then either TMTI (default) or tTMTI is used.}
}
\value{
An approximation of the function \eqn{\gamma^m(x)} under the
assumption that all p-values are independent and exactly uniform
}
\description{
Function to bootstrap the Cumulative Distribution Functions (CDFs) of the TMTI statistics.
}
\examples{
## Get an approximation of gamma
gamma_function <- gamma_bootstrapper(10)
## Evaluate it in a number, say .2
gamma_function(.2)
}
