% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxOR.R
\name{discretizeAge}
\alias{discretizeAge}
\title{Discretize the age variable according to the two cut-off points}
\usage{
discretizeAge(data, cutoffs)
}
\arguments{
\item{data}{Data frame with column: age}

\item{cutoffs}{The cut-off points of the age range}
}
\value{
A modified data frame with a new column: age_p
}
\description{
Discretize the age variable according to the two cut-off points
}
\examples{
# Generate simulated data dataC
dataC <- createData(200)

# Fit the semi-parametric model
spm.fit <- fitSemiParamModel(dataC)

# Find two cut-off points
dataC <- findCutoffs(spm.fit, dataC)

# Calculate the two cut-off points after limiting sensitivity se and specificity sp
result <- calculateCutoffs(dataC)
cutoffs <- result$cutoffs
dataC2 <- result$filteredData

# Discretize age variable based on the two cutoffs
dataC2 <- discretizeAge(dataC2, cutoffs)
}
